
import java.awt.*;
import java.awt.image.*;
import java.applet.*;
public abstract class Sprite
{
	protected int heightCollision = 60;//percent
	protected int widthCollision = 60;//percent
	private Rectangle collRect = new Rectangle();
	protected Sequence normalSeq = new Sequence();	
	protected Sequence theSequence = normalSeq;	
	protected int xPos;
	protected int yPos;
	protected boolean dead = false;
	protected boolean buried = false;
	protected int theVelocity = 0;
	protected int theZOrder = 0;
	private int theWidth = -1;
	private int theHeight = -1;
	private int typeID;

	protected static Scene theScene;
	private static ImageObserver theImageObserver;
	private static ImageCollection theImageCollection;

	protected final Image getImage( String name )
	{
		return theImageCollection.getImage( name );
	}

	public final void setVelocity( int vel )
	{
		theVelocity = vel;
	}

	public final int getVelocity()
	{
		return theVelocity;
	}

	public Sprite( int type, Scene scene, int xPosition, int yPosition )
	{
		typeID = type;
		theScene = scene;
		theImageCollection = theScene.getImageCollection();
		theImageObserver = theImageCollection.getImageObserver();
		xPos = xPosition;
		yPos = yPosition;
	}

	
	public Sprite( int type, Scene scene, int xPosition, int yPosition, int velocity, int zOrder )
	{
		this(type,scene,xPosition,yPosition);
		theVelocity = velocity;
		theZOrder = zOrder;
	}

	public int getTypeID()
	{
		return typeID;
	}


	public final int getZOrder()
	{
		return theZOrder;
	}

	public final boolean isBuried()
	{
		return buried;
	}

	public void kill()
	{
	}

	
	public final boolean isDead()
	{
		return dead;
	}

	public final int getWidth()
	{
		if( theWidth == -1 )
		{
			return theImageCollection.getWidth( normalSeq.getImage(0) );
		}
		return theWidth;
	}

	public final int getHeight()
	{
		if( theHeight == -1 )
		{
			return theImageCollection.getHeight( normalSeq.getImage(0) );
		}
		return theHeight;
	}


	protected final Rectangle getCollisionRect()
	{
		collRect.width = getWidth()*widthCollision/100;
		collRect.height = getHeight()*heightCollision/100;
		collRect.x = getXPosition()+getWidth()*(100-widthCollision)/200;
		collRect.y = getYPosition()+getHeight()*(100-heightCollision)/200;
		return collRect;
	}

	public final boolean collides( Sprite obj )
	{
		if( obj == this )
		{
			return false;
		}
		Rectangle c = getCollisionRect();
		if( c.width == 0 )
		{
			return false;
		}
		return c.intersects( obj.getCollisionRect() );
	}

	public abstract void collision( Sprite obj );

	
	protected final void setSequence( Sequence seq )
	{
		seq.reset();
		theSequence = seq;
	}

	
	public final void setPosition( int xPosition, int yPosition )
	{
		xPos = xPosition;
		yPos = yPosition;
	}
	
	public final int getYPosition( )
	{
		return yPos;
	}
	
	public final int getXPosition( )
	{
		return xPos;
	}

	
	public void draw( Graphics g )
	{
		g.drawImage( theSequence.advance(), xPos, yPos, theImageObserver );
	/*
		g.setColor( Color.white );
		g.drawRect( collRect.x, collRect.y, collRect.width, collRect.height );
		g.setColor( Color.yellow );
		g.drawRect( getXPosition(), getYPosition(), getWidth(), getHeight() );
	*/
	}
}
