
import java.awt.*;

public final class Target extends Sprite
{
	private static final int Z_ORDER = 1;
	public final static int ID = 0;
	private int count = 0;
	private Sequence hitSeq = new Sequence();
	private boolean hit = false;
	private static boolean first = true;
	private boolean down = false;
	private int attackIntervalHigh;
	private int attackIntervalLow;
	private int attackCountdown;
	
	public Target(  Scene scene, int xPosition, int yPosition )
	{
		super( ID, scene, xPosition, yPosition, scene.getProperty("TARGET_VELOCITY"), Z_ORDER );
		normalSeq.addImage( getImage("target1.gif")  );
		normalSeq.addImage( getImage("target2.gif")  );
		normalSeq.addImage( getImage("target3.gif")  );
		normalSeq.addImage( getImage("target4.gif")  );
		hitSeq.addImage( getImage("target1.gif")  );
		attackIntervalHigh = 200 / getVelocity() + 1;
		attackIntervalLow = 20 / getVelocity() + 1;
		attackCountdown = Tools.getRandomInt(attackIntervalLow,attackIntervalHigh);
	}

	private int getPoints()
	{
		switch(count)
		{
			case 0:
			{
				return 20;
			}
			case 1:
			{
				return 12;
			}
			case 2:
			{
				return 8;
			}
			case 3:
			{
				return 6;
			}
			case 4:
			{
				return 3;
			}
			default:
			{
				return 1;
			}
		}
		
	}

	public void collision( Sprite obj )
	{
		if( obj.getTypeID() == Missile.ID && !hit )
		{
			heightCollision = 0;
			widthCollision = 0;
			dead = true;
			setPosition( xPos+getWidth()/2-hitSeq.getWidth(theScene)/2, yPos+getHeight()/2-hitSeq.getHeight(theScene)/2 );
			setSequence( hitSeq );
			hit = true;
			int points = getPoints();
			theScene.drawText( ""+points, new Font("Helvetica",Font.BOLD,24), Color.red, xPos+10, yPos+30, 8 );
			theScene.score( points  );
			theScene.addObject( new Target( theScene, -100, 0) );
		}
	}

	public void kill()
	{
		buried = theVelocity != 0;
		dead = true;
	}

	public void draw( Graphics g )
	{
		if( !dead &&  (--attackCountdown == 0)  )
		{
			attackCountdown = Tools.getRandomInt( attackIntervalLow, attackIntervalHigh );
			Rectangle collRect = getCollisionRect();
			theScene.addObject( new Droppings( theScene, collRect.x + collRect.width/2, collRect.y + collRect.height/2) );
		}
		if( hit )
		{
			if( down )
			{
				super.draw( g );
				return;
			}
			if( yPos >= theScene.getHeight()-getHeight() )
			{
				theVelocity = 0;
				down = true;
				hit = false;
				return;
			}
			else
			{
				super.draw( g );
				yPos += 10;
				return;
			}
		}
		if( getXPosition() >= theScene.getWidth() )
		{
			if( ++count == 4 )
			{
				theScene.death();
				count = 0;
				dead = true;
				buried = true;
				return;
			}
			xPos =  -getWidth();
			yPos += getHeight();
		}
		super.draw( g );
		xPos += theVelocity;
	}

}

