Imports System.Windows.Forms

Public Class Dialog1Pro

    Private T5Value As Short
    Private T6Value As Short
    Private pic As Image

    Private Sub Cancel_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)
        Me.DialogResult = System.Windows.Forms.DialogResult.Cancel
        Me.Close()
    End Sub

    Private Sub TrackBar1_ValueChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles TrackBar1.ValueChanged
        Try
            With Form1
                .Depth = TrackBar1.Value
                .PictureBox3.Width = .Depth * 2 + .PictureBox7.Width
                .PictureBox3.Height = .Depth * 2 + .PictureBox7.Height
                .CenterImage()
                .PictureBox3.Invalidate()
                '.PictureBox3.Refresh()
            End With
            TextBox1.Text = TrackBar1.Value
        Catch
            MessageBox.Show(Err.Description)
        End Try
    End Sub

    Private Sub TrackBar3_MouseLeave(ByVal sender As Object, ByVal e As System.EventArgs) Handles TrackBar3.MouseLeave
        Form1.FitWindowSize()
    End Sub

    Private Sub TrackBar3_ValueChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles TrackBar3.ValueChanged
        Try
            With Form1
                .PictureBox2.Width = Me.TrackBar3.Value * 2 + .PictureBox1.Width
                .PictureBox3.Width = .Depth * 2 + .PictureBox7.Width
                .PictureBox3.Height = .Depth * 2 + .PictureBox7.Height
                .CenterImage()
                .PictureBox3.Refresh()
                .AddMatTexture()
            End With
            TextBox2.Text = TrackBar3.Value
        Catch
            MessageBox.Show(Err.Description)
        End Try
    End Sub

    Private Sub TrackBar4_MouseLeave(ByVal sender As Object, ByVal e As System.EventArgs) Handles TrackBar4.MouseLeave
        Form1.FitWindowSize()
    End Sub

    Private Sub TrackBar4_ValueChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles TrackBar4.ValueChanged
        Try
            With Form1
                .PictureBox2.Height = Me.TrackBar4.Value * 2 + .PictureBox1.Height
                .PictureBox3.Width = .Depth * 2 + .PictureBox7.Width
                .PictureBox3.Height = .Depth * 2 + .PictureBox7.Height
                .CenterImage()
                .PictureBox3.Refresh()
                .AddMatTexture()
            End With
            TextBox3.Text = TrackBar4.Value
        Catch
            MessageBox.Show(Err.Description)
        End Try
    End Sub

    Private Sub Dialog1Pro_Disposed(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Disposed
        pic.Dispose()
    End Sub

    Private Sub Dialog1_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        Dim T2Value As Integer
        Dim T3Value As Integer
        Dim T4Value As Integer
        Dim PicBox As PictureBox

        ToolTip1.SetToolTip(Me.TrackBar1, "Adjusting thickness of frame.")
        ToolTip2.SetToolTip(Me.TrackBar2, "Adjusting size of picture.")
        ToolTip3.SetToolTip(Me.TrackBar3, "Adjusting width of matt1.")
        ToolTip4.SetToolTip(Me.TrackBar4, "Adjusting height of matt1.")

        Try
            With Form1
                T3Value = (.PictureBox2.Width - .PictureBox1.Width) * 0.5
                TrackBar1.Value = .Depth
            End With
            If T3Value <= Me.TrackBar3.Minimum Then
                Me.TrackBar3.Value = Me.TrackBar3.Minimum
            ElseIf T3Value > Me.TrackBar3.Maximum Then
                Me.TrackBar3.Value = Me.TrackBar3.Maximum
            Else
                Me.TrackBar3.Value = T3Value
            End If

            T4Value = (Form1.PictureBox2.Height - Form1.PictureBox1.Height) * 0.5

            If T4Value <= Me.TrackBar4.Minimum Then
                Me.TrackBar4.Value = Me.TrackBar4.Minimum
            ElseIf T4Value > Me.TrackBar4.Maximum Then
                Me.TrackBar4.Value = Me.TrackBar4.Maximum
            Else
                Me.TrackBar4.Value = T4Value
            End If

            PicBox = Form1.PictureBox1
            If PicBox.Width < PicBox.Height Then
                T2Value = PicBox.Width
            Else
                T2Value = PicBox.Height
            End If

            If T2Value <= Me.TrackBar2.Minimum Then
                Me.TrackBar2.Value = Me.TrackBar2.Minimum
            ElseIf T2Value > Me.TrackBar2.Maximum Then
                Me.TrackBar2.Value = Me.TrackBar2.Maximum
            Else
                Me.TrackBar2.Value = T2Value
            End If
            If Not Form1.PictureBox1.Image Is Nothing Then
                Me.PictureBox1.Image = Form1.PictureBox1.Image
            End If

            With Form1
                If T5Value >= TrackBar5.Maximum Then
                    TrackBar5.Value = TrackBar5.Maximum
                ElseIf T5Value < TrackBar5.Minimum Then
                    TrackBar5.Value = TrackBar5.Minimum
                Else
                    TrackBar5.Value = T5Value
                End If

                If T6Value >= TrackBar6.Maximum Then
                    TrackBar6.Value = TrackBar6.Maximum
                ElseIf T6Value < TrackBar6.Minimum Then
                    TrackBar6.Value = TrackBar6.Minimum
                Else
                    TrackBar6.Value = T6Value
                End If

                If CheckBox1.CheckState = CheckState.Checked Then
                    TrackBar6.Visible = False
                    TrackBar6.Enabled = False
                    TextBox5.Visible = False
                Else
                    TrackBar6.Visible = True
                    TrackBar6.Enabled = True
                    TextBox5.Visible = True
                End If
            End With

        Catch
            MessageBox.Show(Err.Description)
        End Try
    End Sub

    Private Sub TrackBar2_ValueChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles TrackBar2.ValueChanged

        Dim TrackValue As Integer
        Try
            With Form1
                TrackValue = Me.TrackBar2.Value
                pic = Form1.PictureBox1.Image
                If Not pic Is Nothing Then
                    If pic.Width < pic.Height Then
                        Form1.PictureBox1.Width = TrackValue
                        Form1.PictureBox1.Height = pic.Height / pic.Width * TrackValue
                    Else
                        Form1.PictureBox1.Height = TrackValue
                        Form1.PictureBox1.Width = pic.Width / pic.Height * TrackValue
                    End If
                    Form1.CenterImage()
                End If
                Form1.CenterImage()
                Form1.PictureBox1.SizeMode = PictureBoxSizeMode.StretchImage
            End With
            TextBox6.Text = TrackBar2.Value
        Catch
            MessageBox.Show(Err.Description)
        End Try
    End Sub

    Private Sub FitWindow_Click(ByVal sender As Object, ByVal e As System.EventArgs)
        Form1.FitWindowSize()
    End Sub

    Private Sub Button1_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles Button1.Click
        Catalogue.Show()
    End Sub

    Private Sub Button2_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles Button2.Click

        Me.Close()
    End Sub

    Private Sub TrackBar5_ValueChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles TrackBar5.ValueChanged
        Try
            T5Value = TrackBar5.Value
            With Form1
                .WdblMatSlit = T5Value
                If CheckBox1.CheckState = CheckState.Checked Then
                    T6Value = T5Value
                    .HdblmatSlit = T5Value
                End If
                .CenterImage()
                TextBox4.Text = TrackBar5.Value
            End With
        Catch
            MessageBox.Show(Err.Description)
        End Try
    End Sub

    Private Sub TrackBar6_ValueChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles TrackBar6.ValueChanged
        Try
            T6Value = TrackBar6.Value
            With Form1
                .HdblmatSlit = T6Value
                .CenterImage()
            End With
            TextBox5.Text = TrackBar6.Value
        Catch
            MessageBox.Show(Err.Description)
        End Try
    End Sub

    Private Sub CheckBox1_CheckStateChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles CheckBox1.CheckStateChanged
        Try
            With Form1
                If CheckBox1.CheckState = CheckState.Checked Then
                    TrackBar6.Visible = False
                    TrackBar6.Enabled = False
                    T6Value = T5Value
                    TextBox5.Visible = False
                Else
                    TrackBar6.Visible = True
                    TrackBar6.Enabled = True
                    TrackBar6.Value = T6Value
                    TextBox5.Visible = True
                End If
                .CenterImage()
            End With
        Catch
            MessageBox.Show(Err.Description)
        End Try
    End Sub

    Public Property T5() As Short
        Get
            T5 = T5Value
        End Get
        Set(ByVal value As Short)
            T5Value = value
        End Set
    End Property

    Public Property T6() As Short
        Get
            T6 = T6Value
        End Get
        Set(ByVal value As Short)
            T6Value = value
        End Set
    End Property

End Class
