Imports System.Windows.Forms

Public Class Dialog7

    Private myGamma As Single
    Public Sub SetGammaValue(ByVal e As PaintEventArgs, ByVal I As Integer, ByVal box1 As PictureBox, ByVal box2 As PictureBox)
        If Form1.ImageSet.Count = 0 Then Exit Sub
        If Form1.InitalImageset.Count = 0 Then Exit Sub
        Dim imageAttr As New Imaging.ImageAttributes
        Dim FrameWidth As Integer = Math.Max(Form1.PictureBox3.Width * 1.5, Form1.PictureBox2.Height * 1.5)
        Dim rect As New Rectangle(0, 0, FrameWidth, 42)

        If myGamma = 0 Then myGamma = 0.1
        imageAttr.SetGamma(myGamma)
        Try
            Using Bmp As New Bitmap(FrameWidth, 40)
                Using G As Graphics = Graphics.FromImage(Bmp)
                    G.DrawImage(box1.Image, rect, 0, 0, 80, 40, GraphicsUnit.Pixel, imageAttr)
                    G.CopyFromScreen(0, 0, 80, 40, box1.Size)
                    box2.Image = System.Drawing.Image.FromHbitmap(Bmp.GetHbitmap)
                End Using
            End Using
        Catch
            MessageBox.Show(Err.Description)
        End Try

    End Sub
    Private Sub OK_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles OK_Button.Click
        With Form1.ImageSet
            .Clear()
            .Add(PictureBox5.Image)
            .Add(PictureBox6.Image)
            .Add(PictureBox7.Image)
            .Add(PictureBox8.Image)
        End With
        Form1.Refresh()
        Form1.FrameGamma = myGamma

        Me.DialogResult = System.Windows.Forms.DialogResult.OK
    End Sub

    Private Sub Cancel_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Cancel_Button.Click
        Me.DialogResult = System.Windows.Forms.DialogResult.Cancel
        Me.Close()
    End Sub

    Private Sub PictureBox1_Paint(ByVal sender As Object, ByVal e As System.Windows.Forms.PaintEventArgs) Handles PictureBox1.Paint
        SetGammaValue(e, 1, sender, PictureBox5)
    End Sub


    Private Sub PictureBox2_Paint(ByVal sender As Object, ByVal e As System.Windows.Forms.PaintEventArgs) Handles PictureBox2.Paint
        SetGammaValue(e, 2, sender, PictureBox6)
    End Sub

    Private Sub PictureBox3_Paint(ByVal sender As Object, ByVal e As System.Windows.Forms.PaintEventArgs) Handles PictureBox3.Paint
        SetGammaValue(e, 3, sender, PictureBox7)
    End Sub

    Private Sub PictureBox4_Paint(ByVal sender As Object, ByVal e As System.Windows.Forms.PaintEventArgs) Handles PictureBox4.Paint
        SetGammaValue(e, 4, sender, PictureBox8)
    End Sub

    Private Sub TrackBar1_ValueChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles TrackBar1.ValueChanged
        myGamma = CSng((TrackBar1.Value / 50) ^ Math.Log(10, 2))
        TextBox1.Text = myGamma
        PictureBox1.Refresh()
        PictureBox2.Refresh()
        PictureBox3.Refresh()
        PictureBox4.Refresh()
    End Sub

    Private Sub Dialog7_Disposed(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Disposed
        Form1.Refresh()
    End Sub

    Private Sub Dialog7_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Form1.InitalImageset.Count = 0 Then Exit Sub

        PictureBox1.Image = Form1.InitalImageset(1)
        PictureBox2.Image = Form1.InitalImageset(2)
        PictureBox3.Image = Form1.InitalImageset(3)
        PictureBox4.Image = Form1.InitalImageset(4)
        myGamma = Form1.FrameGamma
        If myGamma < 0.1 Then
            TrackBar1.Value = 1
            TextBox1.Text = 0.1
        Else
            TrackBar1.Value = CInt(50 * myGamma ^ (1 / Math.Log(10, 2)))
            TextBox1.Text = myGamma
        End If
    End Sub
End Class
