Public Class Form1

    Private III As Long
    Private ImportedImage As Image
    Private WithEvents cd As New ColorDialog
    Private isCallingColorDialog As Boolean = False
    Private myColors As Integer()
    Private myFileName As String
    Private covBrush As SolidBrush
    Private covAlpha As Integer
    Private covBaseColor As Color
    Private dW As Integer, dH As Integer

    Private texInitialImageSet As Collection
    Private texImageSet As Collection
    Private texDepth As Int32
    Private texGamma As Single
    Private TitleFileName As String
    Private TitleFileNameFullPath As String

    Private strImportedMattTexture As String
    Private myMattTexureImage As Bitmap

    '%%%%%%%%%%%%%%%%%%%%%%%%%%% For DRAG & DROP Starts
    Private DroppedImage As Image '%%%%%

    ' ****** for Matt Sections Effects
    Private wmatt As Integer = 3
    Private wfram As Integer = 2
    Private eps As Integer = 1
    Private SecColor As Color() = {Color.White, Color.White, Color.White, Color.White}
    Private BottomColor As Color = Color.White
    Private ShadeFrame As Color = Color.Indigo

    Private Sub DisposeAll()

        On Error Resume Next
        ImportedImage.Dispose()
        myMattTexureImage.Dispose()
        MattTexture.Dispose()
        DroppedImage.Dispose()
        covBrush.Dispose()
        cd.Dispose()
    End Sub

    Public Sub New()
        Me.AllowDrop = True
        InitializeComponent()
    End Sub

    Protected Overrides Sub OnPaint(ByVal e As PaintEventArgs) '%%%%%
        MyBase.OnPaint(e)
        If Not (Me.DroppedImage Is Nothing) Then
            PictureBox1.Image = Me.DroppedImage
            SetBox1Size(Me.DroppedImage)
            SetImageTitle(TitleFileNameFullPath)
        End If
    End Sub

    Private Sub SetBox1Size(ByVal myImage As Image)
        Me.PictureBox1.Width = myImage.Width / myImage.Height * Me.PictureBox1.Height
        Me.PictureBox1.SizeMode = PictureBoxSizeMode.StretchImage
    End Sub

    Private Sub SetBox3Size()
        PictureBox3.Width = PictureBox7.Width + Depth * 2.0
        PictureBox3.Height = PictureBox7.Height + Depth * 2.0 + eps
    End Sub

    Private Sub SetBox4Size()
        If dW = 0 Then
            PictureBox4.Width = PictureBox1.Width
        Else
            PictureBox4.Width = PictureBox6.Width + dW * 2

        End If
        If dH = 0 Then
            PictureBox4.Height = PictureBox1.Height
        Else
            PictureBox4.Height = PictureBox6.Height + dH * 2
        End If

    End Sub

    Private Sub SetImageTitle(ByVal myFilepath As String)
        Dim Ipos As Integer
        Ipos = InStrRev(myFilepath, "\", -1, CompareMethod.Text)
        TitleFileName = Microsoft.JScript.StringPrototype.substr(myFilepath, Ipos, Len(myFilepath))
        Me.Text = "WaterColorFrameSimulator " & TitleFileName
    End Sub

    Private Sub Form1_Disposed(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Disposed
        DisposeAll()
    End Sub

    Private Sub Form1_DragDrop(ByVal sender As Object, ByVal e As DragEventArgs) Handles MyBase.DragDrop '%%%%%
        If e.Data.GetDataPresent(DataFormats.FileDrop) Then
            Dim files As String() = CType(e.Data.GetData(DataFormats.FileDrop), String())
            Try
                Me.DroppedImage = Bitmap.FromFile(files(0))
            Catch ex As Exception
                MessageBox.Show(ex.Message)
                Return
            End Try
        End If
        If e.Data.GetDataPresent(DataFormats.Bitmap) Then
            Try
                Me.DroppedImage = CType(e.Data.GetData(DataFormats.Bitmap), Image)
            Catch ex As Exception
                MessageBox.Show(ex.Message)
                Return
            End Try
        End If
        Me.Invalidate()
        Me.SetBox1Size(Me.DroppedImage)
        Me.CenterImage()
    End Sub

    Private Sub Form1_DragEnter(ByVal sender As Object, ByVal e As DragEventArgs) Handles MyBase.DragEnter  '%%%%%
        If e.Data.GetDataPresent(DataFormats.Bitmap) _
           Or e.Data.GetDataPresent(DataFormats.FileDrop) Then
            e.Effect = DragDropEffects.Copy
        Else
            e.Effect = DragDropEffects.None
        End If
    End Sub
    '%%%%%%%%%%%%%%%%%%%%%%%%%%% For DRAG & DROP Ends 

    Private Sub ImportToolStripMenuItem_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles ImportToolStripMenuItem.Click
        Dim myDirectory As String
        Dim dlg As OpenFileDialog
        'Dim ImportedImage As Image
        Try
            myDirectory = "My Pictures"
            dlg = OpenFileDialog1
            With dlg
                .Filter = "Image Files(*.jpg,*.bmp,*.gif,*png)|*.jpg;*.bmp;*.gif;*.png|All Files (*.*)|*.*"
                .Title = "Import Picture"
                .FileName = ""
                .InitialDirectory = myDirectory
                .Multiselect = False
                If .ShowDialog() = Windows.Forms.DialogResult.OK Then
                    myFileName = .FileName
                    Me.PictureBox1.SizeMode = PictureBoxSizeMode.Zoom

                    '################@Enables to ovaerwrite on opended file.
                    Using fs As IO.FileStream = New IO.FileStream(myFileName, IO.FileMode.Open, IO.FileAccess.ReadWrite)
                        ImportedImage = System.Drawing.Image.FromStream(fs)
                        fs.Close()
                    End Using
                    '################

                    Me.PictureBox1.Image = ImportedImage
                    SetBox1Size(ImportedImage)
                    SetImageTitle(myFileName)
                End If
                .Dispose()
            End With
            CenterImage()
            Me.Refresh()
        Catch
            MessageBox.Show(Err.Description)
        End Try
    End Sub


    Private Sub Form1_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        InitalImageset = New Collection
        ImageSet = New Collection

        PictureBox4.Width = PictureBox1.Width + 12
        PictureBox4.Height = PictureBox1.Height + 12
        PictureBox3.Width = PictureBox2.Width + 60
        PictureBox3.Height = PictureBox2.Height + 60

        Depth = (PictureBox3.Width - PictureBox7.Width) * 0.5
        dW = 2 : dH = 2
        CenterImage()
    End Sub

    Public Sub CenterImage()
        Try
            Me.PictureBox1.Left = Me.Width * 0.5 - Me.PictureBox1.Width * 0.5
            Me.PictureBox1.Top = Me.Height * 0.5 - Me.PictureBox1.Height * 0.5
            CuttingMatt(PictureBox6, PictureBox1, 255, 220, 160, 100, wmatt, eps, BottomColor)
            SetBox4Size()
            BoxLocation(PictureBox4, PictureBox6)
            CuttingMatt(PictureBox5, PictureBox4, 255, 220, 160, 100, wmatt, eps, BottomColor)
            BoxLocation(PictureBox2, PictureBox5)
            SetBox3Size()
            CuttingMatt(PictureBox7, PictureBox2, 255, 220, 160, 100, wfram, eps, ShadeFrame) ' %%% ŕςB
            SetBox3Size()
            BoxLocation(PictureBox3, PictureBox7)
        Catch
            MessageBox.Show(Err.Description)
        End Try
    End Sub

    Private Sub CuttedBoxLocation(ByVal OuterBox As PictureBox, ByVal InnerBox As PictureBox)
        OuterBox.Left = InnerBox.Left + InnerBox.Width * 0.5 - OuterBox.Width * 0.5
        OuterBox.Top = InnerBox.Top + InnerBox.Height * 0.5 - OuterBox.Height * 0.5 - eps
    End Sub

    Private Sub BoxLocation(ByVal OuterBox As PictureBox, ByVal InnerBox As PictureBox)
        OuterBox.Left = InnerBox.Left + InnerBox.Width * 0.5 - OuterBox.Width * 0.5
        OuterBox.Top = InnerBox.Top + InnerBox.Height * 0.5 - OuterBox.Height * 0.5
    End Sub

    Private Sub CuttedBoxSizeAndLocation(ByVal BoxMattCut As PictureBox, ByVal BoxInside As PictureBox)
        BoxMattCut.Width = BoxInside.Width + wmatt * 2
        BoxMattCut.Height = BoxInside.Height + wmatt * 2 + eps
        BoxMattCut.Left = BoxInside.Left + BoxInside.Width * 0.5 - BoxMattCut.Width * 0.5
        BoxMattCut.Top = BoxInside.Top + BoxInside.Height * 0.5 - BoxMattCut.Height * 0.5 - eps
    End Sub


    Private Sub Matt1ToolStripMenuItem_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles Matt1ToolStripMenuItem.Click
        Try
            ShowColorDialog(Me.PictureBox2)
            Me.PictureBox3.Invalidate()
        Catch
            MessageBox.Show(Err.Description)
        End Try
    End Sub

    Private Sub FrameToolStripMenuItem_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles FrameToolStripMenuItem.Click
        ShowColorDialog(Me.PictureBox3)
        Me.Refresh()
    End Sub

    Public Sub ShowColorDialog(ByVal box As PictureBox)
        isCallingColorDialog = True
        cd = ColorDialog1
        Try
            cd.Color = box.BackColor
            cd.AllowFullOpen = True
            cd.SolidColorOnly = False
            cd.ShowHelp = True
            cd.CustomColors = myColors
            'Put Colors on [Custom Colors]
            'cd.CustomColors = New Integer() {&HFFFFFF, &HD3F1FC, &HFCD2C2, _
            '    &HCED0DB, &HE4EBEA, &HECE3E1, &HE4EBE4, &HE0E9E2, &H1D321F, _
            '    &H10273D, &H332226, &H1C1522, &H242415, &H152420, _
            '    &H162329, &H170A34}
            If cd.ShowDialog() = Windows.Forms.DialogResult.OK Then
                box.BackColor = cd.Color
            End If
            myColors = cd.CustomColors
            isCallingColorDialog = False
        Catch
            MessageBox.Show(Err.Description)
        End Try
    End Sub

    Private Sub PickUp_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles GetColorToolStripMenuItem.Click
        Dialog2.Show()
    End Sub

    Private Sub CopyImage_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles PreviewToolStripMenuItem.Click
        Dim PreviewForm As New Form2
        PreviewForm.Text = "Preview " & TitleFileName
        PreviewForm.Show()
    End Sub

    Private Sub SizeToolStripMenuItem_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles SizeToolStripMenuItem.Click
        Dialog1Pro.ShowDialog()
    End Sub

    Private Sub HelpToolStripMenuItem_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles HelpToolStripMenuItem.Click
        Dialog5.Show()
    End Sub

    Private Sub cd_HelpRequest(ByVal sender As Object, ByVal e As System.EventArgs) Handles cd.HelpRequest
        Dialog4.Show()
    End Sub

    Public Property ImageFileName() As String
        Get
            ImageFileName = myFileName
        End Get
        Set(ByVal value As String)
            myFileName = value
        End Set
    End Property

    Private Sub CloseToolStripMenuItem_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles CloseToolStripMenuItem.Click
        DisposeAll()
        Me.Close()
    End Sub
 

    'Private Sub vtFbViToolStripMenuItem_Click(ByVal sender As Object, ByVal e As System.EventArgs)
    '    Dialog1Pro.Show()
    'End Sub

    Private Sub PictureBox3_Paint(ByVal sender As Object, ByVal e As System.Windows.Forms.PaintEventArgs) Handles PictureBox3.Paint
        Dim Direction As Int32
        Dim PointU(5) As Point
        Dim PointD(5) As Point
        Dim PointL(5) As Point
        Dim PointR(5) As Point

        If isCallingColorDialog Then Exit Sub
        If ImageSet.Count = 0 Then
            Exit Sub
        End If
        Direction = 1

        'Upper Piece
        PointU(0) = New Point(0, 0)
        PointU(1) = New Point(sender.Width, 0)
        PointU(2) = New Point(sender.Width - Depth, Depth)
        PointU(3) = New Point(Depth, Depth)
        PointU(4) = New Point(0, 0)

        'Left Piece
        PointL(0) = New Point(0, 0)
        PointL(1) = New Point(0, sender.height)
        PointL(2) = New Point(Depth, sender.height - Depth)
        PointL(3) = New Point(Depth, Depth)
        PointU(4) = New Point(0, 0)
        'Down Piece
        PointD(0) = New Point(0, sender.height)
        PointD(1) = New Point(sender.Width, sender.height)
        PointD(2) = New Point(sender.Width - Depth, sender.height - Depth)
        PointD(3) = New Point(Depth, sender.height - Depth)
        PointD(4) = New Point(0, sender.height)
        'Right Piece
        PointR(0) = New Point(sender.Width, 0)
        PointR(1) = New Point(sender.Width, sender.height)
        PointR(2) = New Point(sender.Width - Depth, sender.height - Depth)
        PointR(3) = New Point(sender.Width - Depth, Depth)
        PointR(4) = New Point(sender.Width, 0)

        DrawTraipzoid(sender, e, Depth, PointU, PointD, PointL, PointR)

    End Sub

    Private Sub DrawTraipzoid(ByVal box As PictureBox, ByVal e As System.Windows.Forms.PaintEventArgs, _
    ByVal Depth As Int32, ByVal PointU As Point(), ByVal PointD As Point(), ByVal PointL As Point(), ByVal PointR As Point())

        Dim texU As TextureBrush
        Dim texD As TextureBrush
        Dim texL As TextureBrush
        Dim texR As TextureBrush
        Dim myGrBrushU As Drawing2D.LinearGradientBrush
        Dim myGrBrushD As Drawing2D.LinearGradientBrush
        Dim myGrBrushL As Drawing2D.LinearGradientBrush
        Dim myGrBrushR As Drawing2D.LinearGradientBrush

        Dim pathU As New Drawing2D.GraphicsPath
        Dim pathD As New Drawing2D.GraphicsPath
        Dim pathL As New Drawing2D.GraphicsPath
        Dim pathR As New Drawing2D.GraphicsPath

        pathU.AddLines(PointU)
        pathD.AddLines(PointD)
        pathL.AddLines(PointL)
        pathR.AddLines(PointR)
        If ImageSet.Count = 0 Then
            Exit Sub
        End If

        texU = myTexture(ImageSet(1), PointU)
        texD = myTexture(ImageSet(2), PointD)
        texL = myTexture(ImageSet(3), PointL)
        texR = myTexture(ImageSet(4), PointR)

        myGrBrushU = linGrBrush(PointU)
        myGrBrushD = linGrBrush(PointD)
        myGrBrushL = linGrBrush(PointL)
        myGrBrushR = linGrBrush(PointR)

        e.Graphics.FillPath(texU, pathU)
        e.Graphics.FillPath(texD, pathD)
        e.Graphics.FillPath(texL, pathL)
        e.Graphics.FillPath(texR, pathR)

        'Cover transparent color on the frame.
        If CoverBrush Is Nothing Then Exit Sub
        e.Graphics.FillPath(CoverBrush, pathU)
        e.Graphics.FillPath(CoverBrush, pathD)
        e.Graphics.FillPath(CoverBrush, pathL)
        e.Graphics.FillPath(CoverBrush, pathR)

        ' Release Objects
        texU.Dispose()
        texD.Dispose()
        texL.Dispose()
        texR.Dispose()

        myGrBrushU.Dispose()
        myGrBrushD.Dispose()
        myGrBrushL.Dispose()
        myGrBrushR.Dispose()

    End Sub

    Private Function linGrBrush(ByVal points As Point()) As Drawing2D.LinearGradientBrush
        Dim GradPoint1 As Point, GradPoint2 As Point

        GradPoint1 = New Point((points(0).X + points(1).X) * 0.5, (points(0).Y + points(1).Y) * 0.5)
        GradPoint2 = New Point((points(2).X + points(3).X) * 0.5, (points(2).Y + points(3).Y) * 0.5)
        If GradPoint1.X = GradPoint2.X Then
            If GradPoint1.Y < GradPoint2.Y Then
                GradPoint2.Y = GradPoint2.Y + 2
            Else
                GradPoint2.Y = GradPoint2.Y - 2
            End If
        ElseIf GradPoint1.Y = GradPoint2.Y Then
            If GradPoint1.X < GradPoint2.X Then
                GradPoint2.X = GradPoint2.X + 2
            Else
                GradPoint2.X = GradPoint2.X - 2
            End If

        End If

        linGrBrush = New Drawing2D.LinearGradientBrush(GradPoint1, GradPoint2, _
                        Color.FromArgb(255, 255, 0, 0), Color.FromArgb(255, 0, 0, 255))

        Return (linGrBrush)
    End Function

    Private Function myTexture(ByVal image1 As Bitmap, ByVal points As Point()) As TextureBrush

        Dim GradPoint1 As Point, GradPoint2 As Point
        Dim myScale As Single
        Dim m11 As Single
        Dim m12 As Single
        Dim m21 As Single
        Dim m22 As Single
        Dim dx As Single
        Dim dy As Single
        Dim MyValue As New Drawing2D.Matrix(m11, m12, m21, m22, dx, dy)
        myTexture = New TextureBrush(image1)
        myTexture.WrapMode = Drawing2D.WrapMode.Tile

        GradPoint1 = New Point((points(0).X + points(1).X) * 0.5, (points(0).Y + points(1).Y) * 0.5)
        GradPoint2 = New Point((points(2).X + points(3).X) * 0.5, (points(2).Y + points(3).Y) * 0.5)
        If GradPoint1.X = GradPoint2.X Then
            If GradPoint1.Y < GradPoint2.Y Then
                myScale = Depth / ImageSet(1).Height
                myTexture.ScaleTransform(1, myScale)
            Else
                myTexture.RotateTransform(180)
                MyValue = myTexture.Transform
                myScale = Depth / ImageSet(2).Height
                dy = texOffset(PictureBox3.Height, image1.Height * myScale)
                MyValue.Translate(0, dy)
                myTexture.Transform = MyValue
                myTexture.ScaleTransform(1, myScale)
                myTexture.Transform.Translate(0, dy)
            End If
        ElseIf GradPoint1.Y = GradPoint2.Y Then
            If GradPoint1.X < GradPoint2.X Then
                myTexture.RotateTransform(270)
                myScale = Depth / ImageSet(3).Height
                myTexture.ScaleTransform(1, myScale)
            Else
                myTexture.RotateTransform(90)
                MyValue = myTexture.Transform
                myScale = Depth / ImageSet(4).Height
                dy = texOffset(PictureBox3.Width, image1.Height * myScale)
                MyValue.Translate(0, dy)
                myTexture.Transform = MyValue
                myTexture.ScaleTransform(1, myScale)
                myTexture.Transform.Translate(0, dy)
            End If
        End If
        Return myTexture
        MyValue.Dispose()

    End Function

    Private Function texOffset(ByVal picWidth As Int32, ByVal patWidth As Int32) As Int32
        texOffset = (Int(picWidth / patWidth) + 1) * patWidth - picWidth
        Return texOffset
    End Function

    Friend Property InitalImageset() As Collection
        Get
            InitalImageset = texInitialImageSet
        End Get
        Set(ByVal value As Collection)
            texInitialImageSet = value
        End Set
    End Property

    Friend Property ImageSet() As Collection
        Get
            ImageSet = texImageSet
        End Get
        Set(ByVal value As Collection)
            texImageSet = value
        End Set
    End Property

    Friend Property Depth() As Int32
        Get
            Depth = texDepth
        End Get
        Set(ByVal value As Int32)
            texDepth = value
        End Set
    End Property

    Private Sub ColorFrameToolStripMenuItem_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles ColorFrameToolStripMenuItem.Click
        Try
            Dialog6.Show()
        Catch
            MessageBox.Show(Err.Description)
        End Try
    End Sub

    Friend Property Alpha() As Integer
        Get
            Alpha = covAlpha
        End Get
        Set(ByVal value As Integer)
            covAlpha = value
        End Set
    End Property

    Friend Property CoverBrush() As SolidBrush
        Get
            CoverBrush = covBrush
        End Get
        Set(ByVal value As SolidBrush)
            covBrush = value
        End Set
    End Property

    Friend Property BaseColor() As Color
        Get
            BaseColor = covBaseColor
        End Get
        Set(ByVal value As Color)
            covBaseColor = value
        End Set
    End Property

    Private Sub Matt2ToolStripMenuItem1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Matt2ToolStripMenuItem1.Click
        ShowColorDialog(Me.PictureBox4)
        Me.PictureBox3.Invalidate()
    End Sub

    Friend Property WdblMatSlit() As Integer
        Get
            WdblMatSlit = dW
        End Get
        Set(ByVal value As Integer)
            dW = value
        End Set
    End Property

    Friend Property HdblmatSlit() As Integer
        Get
            HdblmatSlit = dH
        End Get
        Set(ByVal value As Integer)
            dH = value
        End Set
    End Property

    Private Sub GammaToolStripMenuItem_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles GammaToolStripMenuItem.Click
        Dialog7.Show()
    End Sub

    Friend Property FrameGamma() As Single
        Get
            FrameGamma = texGamma
        End Get
        Set(ByVal value As Single)
            texGamma = value
        End Set
    End Property


    Private Sub GetColorToolStripMenuItem_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles GetColorAntWhereToolStripMenuItem.Click
        Form5.Show()
    End Sub

    Private Sub TexMatt1ToolStripMenuItem_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles TexMatt1ToolStripMenuItem.Click
        Form6.Show()
        Me.PictureBox3.Invalidate()
    End Sub

    Public Property MattTexture() As Bitmap
        Get
            MattTexture = myMattTexureImage
        End Get
        Set(ByVal value As Bitmap)
            myMattTexureImage = value
        End Set
    End Property

    Public Sub AddMatTexture()
        Try
            III = III + 1
            If Form5.Visible Then Exit Sub
            If isCallingColorDialog Then Exit Sub
            If Me.MattTexture Is Nothing Then Exit Sub

            Dim rect As New Rectangle(0, 0, 99, 99)
            Me.PictureBox2.Image = New Bitmap(Me.PictureBox2.Width, Me.PictureBox2.Height)

            Dim myGraphics As Graphics = Graphics.FromImage(Me.PictureBox2.Image)
            Dim texture As New TextureBrush(Me.MattTexture)
            texture.WrapMode = Drawing2D.WrapMode.Tile
            myGraphics.FillRectangle(texture, 0, 0, Me.PictureBox2.Width, Me.PictureBox2.Height)

            myGraphics.Dispose()
            texture.Dispose()
        Catch
            MessageBox.Show(Err.Description)
        End Try


    End Sub

    Public Property Importedtexture() As String
        Get
            Importedtexture = strImportedMattTexture
        End Get
        Set(ByVal value As String)
            strImportedMattTexture = value
        End Set
    End Property

    Private Sub RefreshCuttings()
        PictureBox6.Invalidate()
        PictureBox5.Invalidate()
        PictureBox7.Invalidate()
    End Sub

    Private Function myColor(ByVal OrgColor As Color, ByVal IDark As Byte) As Color
        Dim R As Byte, G As Byte, B As Byte
        R = OrgColor.R : G = OrgColor.G : B = OrgColor.B
        If R > IDark Then
            R = R - IDark
        Else
            R = 0
        End If
        If G > IDark Then
            G = G - IDark
        Else
            G = 0
        End If
        If B > IDark Then
            B = B - IDark
        Else
            B = 0
        End If
        myColor = Color.FromArgb(R, G, B)
    End Function

    Private Sub CuttingMatt(ByVal BoxMattCut As PictureBox, ByVal BoxInside As PictureBox, _
        ByVal BottomBright As Integer, ByVal RightBright As Integer, _
        ByVal LeftBright As Integer, ByVal TopBright As Integer, _
        ByVal Iwmatt As Integer, ByVal Ieps As Integer, ByVal CutFaceColor As Color)


        SecColor(0) = Color.FromArgb(TopBright, TopBright, TopBright)
        SecColor(1) = Color.FromArgb(RightBright, RightBright, RightBright)
        SecColor(2) = Color.FromArgb(BottomBright, BottomBright, BottomBright)
        SecColor(3) = Color.FromArgb(LeftBright, LeftBright, LeftBright)

        SecColor(0) = myColor(CutFaceColor, BottomBright - TopBright)
        SecColor(1) = myColor(CutFaceColor, BottomBright - RightBright)
        SecColor(2) = CutFaceColor
        SecColor(3) = myColor(CutFaceColor, BottomBright - LeftBright)

        Dim myBrash1 As New SolidBrush(SecColor(0))
        Dim myBrash2 As New SolidBrush(SecColor(1))
        Dim myBrash3 As New SolidBrush(SecColor(2))
        Dim myBrash4 As New SolidBrush(SecColor(3))

        Dim myBrashes As Brush() = {myBrash1, myBrash2, myBrash3, myBrash4}
        BoxMattCut.Width = BoxInside.Width + Iwmatt * 2
        BoxMattCut.Height = BoxInside.Height + Iwmatt * 2 + Ieps
        BoxMattCut.Top = BoxInside.Top - Iwmatt - Ieps
        BoxMattCut.Left = BoxInside.Left - Iwmatt
        mytrangles(BoxMattCut, myBrashes, Iwmatt)
        myBrash1.Dispose()
        myBrash2.Dispose()
        myBrash3.Dispose()
        myBrash4.Dispose()
    End Sub

    Sub mytrangles(ByVal Box As PictureBox, ByVal myBrushes As Brush(), ByVal Iwmatt As Integer)
        Dim p1 As PointF, p2 As PointF, p3 As PointF, p4 As PointF
        Dim q1 As PointF, q2 As PointF, q3 As PointF, q4 As PointF
        Dim delta As Single
        delta = (Box.Width - Box.ClientSize.Width) / 2.0

        p1.X = delta : p1.Y = delta
        p2.X = CType(Box.ClientSize.Width, Single) : p2.Y = delta
        p3.X = p2.X : p3.Y = CType(Box.ClientSize.Height, Single)
        p4.X = p1.X : p4.Y = p3.Y

        q1.X = p1.X + Iwmatt : q1.Y = p2.Y + Iwmatt + eps
        q2.X = p2.X - Iwmatt : q2.Y = q1.Y
        q3.X = q2.X : q3.Y = p3.Y - Iwmatt
        q4.X = q1.X : q4.Y = q3.Y
        Box.Image = New Bitmap(Box.Width, Box.Height)
        Dim g As Graphics = Graphics.FromImage(Box.Image)

        Dim myPoints1 As PointF() = {p1, p2, q2, q1} : g.FillPolygon(myBrushes(0), myPoints1)
        Dim myPoints2 As PointF() = {p2, p3, q3, q2} : g.FillPolygon(myBrushes(1), myPoints2)
        Dim myPoints3 As PointF() = {p3, p4, q4, q3} : g.FillPolygon(myBrushes(2), myPoints3)
        Dim myPoints4 As PointF() = {p4, p1, q1, q4} : g.FillPolygon(myBrushes(3), myPoints4)

        g.Dispose()
        Box.Invalidate()
    End Sub

    Public Property MattEdgeWidth() As Integer
        Get
            MattEdgeWidth = wmatt
        End Get
        Set(ByVal value As Integer)
            wmatt = value
        End Set
    End Property

    Public Property MattEdgeColor() As Color
        Get
            MattEdgeColor = BottomColor
        End Get
        Set(ByVal value As Color)
            BottomColor = value
        End Set
    End Property

    Public Property FrameShadeWidth() As Integer
        Get
            FrameShadeWidth = wfram
        End Get
        Set(ByVal value As Integer)
            wfram = value
        End Set
    End Property

    Public Property FrameShadeColor() As Color
        Get
            FrameShadeColor = ShadeFrame
        End Get
        Set(ByVal value As Color)
            ShadeFrame = value
        End Set
    End Property

    'Private Sub IvVToolStripMenuItem_Click(ByVal sender As Object, ByVal e As System.EventArgs)
    '    Form7.Show()
    'End Sub

    Private Sub Button1_Click(ByVal sender As Object, ByVal e As System.EventArgs)
        Me.CenterImage()
        Application.DoEvents()
        Me.Refresh()
    End Sub

    Private Sub J^OToolStripMenuItem_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles CatalogueToolStripMenuItem.Click
        Catalogue.Show()
    End Sub

    Private Sub CuttingMattsToolStripMenuItem_Click1(ByVal sender As Object, ByVal e As System.EventArgs) Handles CuttingMattsToolStripMenuItem.Click
        Form7.Show()
    End Sub

    Public Sub FitWindowSize()
        Try
            Me.Width = Me.PictureBox3.Width + 100
            Me.Height = Me.PictureBox3.Height + 100
            If Me.PictureBox1.Width > Me.PictureBox3.Width Then
                Me.Width = Me.PictureBox1.Width + 100
            ElseIf Me.PictureBox1.Height > Me.PictureBox3.Height Then
                Me.Height = Me.PictureBox1.Height + 100
            End If
            Me.CenterImage()
            Me.Refresh()
        Catch
            MessageBox.Show(Err.Description)
        End Try
    End Sub

End Class


