Public Class Form2

    Private Sub Form2_Disposed(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Disposed
        Form1.Refresh()
    End Sub

    Private Sub Form2_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Me.Width = Form1.Width
        Me.Height = Form1.Height
        GetScreenCopy()
    End Sub


    Private Sub pictureBox1_Paint(ByVal sender As Object, ByVal e As System.Windows.Forms.PaintEventArgs)
        Dim g As Graphics = e.Graphics
        Dim rect As New Rectangle(0, 0, PictureBox1.Width, Height)
        g.DrawImage(Form1.PictureBox1.Image, rect)
    End Sub

    Sub GetScreenCopy()
        Dim ScreenSize As Size
        Dim XX As Integer
        Dim YY As Integer
        Dim Form1X As Integer
        Dim Form1Y As Integer
        Dim ClientRect As Rectangle
        Dim FormTytleHeight As Integer
        Dim FormBorderWidth As Integer
        Dim PB2X As Integer
        Dim PB2Y As Integer
        Try
            ClientRect = Form1.ClientRectangle
            FormTytleHeight = Form1.Height - ClientRect.Height
            FormBorderWidth = (Form1.Width - ClientRect.Width) * 0.5
            ScreenSize = Form1.PictureBox3.Size
            Using Bmp As New Bitmap(ScreenSize.Width, ScreenSize.Height)
                Using G As Graphics = Graphics.FromImage(Bmp)
                    Form1X = Form1.Location.X
                    Form1Y = Form1.Location.Y
                    PB2X = Form1.PictureBox3.Location.X
                    PB2Y = Form1.PictureBox3.Location.Y
                    XX = Form1X + PB2X + FormBorderWidth
                    YY = Form1Y + PB2Y + FormTytleHeight - FormBorderWidth
                    G.CopyFromScreen(XX, YY, 0, 0, ScreenSize)
                    Me.PictureBox1.Image = System.Drawing.Image.FromHbitmap(Bmp.GetHbitmap)
                End Using
            End Using
        Catch
            MessageBox.Show(Err.Description)
        End Try
    End Sub

    Private Sub SaveAsToolStripMenuItem_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles SaveAsToolStripMenuItem.Click
        Dim myDirectory As String
        Dim myFileName As String
        Dim bSave As Boolean = True
        Try
            myDirectory = "My Documents"
            With SaveFileDialog1
                .InitialDirectory = myDirectory
                .Filter = "JPG Files (*.jpg)|*.jpg"
                If (.ShowDialog() = Windows.Forms.DialogResult.OK) Then
                    myFileName = .FileName
                    If myFileName = Form1.ImageFileName Then
                        If MessageBox.Show("You are replacing your picture by new image.." & vbLf & "Do you really replace them?", "Confirming to Replace Files.", MessageBoxButtons.YesNo, MessageBoxIcon.Question) = Windows.Forms.DialogResult.No Then
                            bSave = False
                        End If
                    End If
                    If bSave = True Then
                        Me.PictureBox1.Image.Save(myFileName, System.Drawing.Imaging.ImageFormat.Jpeg)
                    End If
                End If
                .Dispose()
            End With
        Catch
            MessageBox.Show(Err.Description)
        End Try
    End Sub

    Private Sub CloseToolStripMenuItem_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles CloseToolStripMenuItem.Click
        Me.Close()
    End Sub
End Class