
Public Structure byteRGB
    Dim R As Byte
    Dim G As Byte
    Dim B As Byte
End Structure

Public Structure doubleHSL
    Dim H As Double
    Dim S As Double
    Dim L As Double
End Structure

Public Class Form6

    Private strDropedFile As String
    Private startPoint As Point
    Private ClippingRect As Rectangle
    Private isClipRectExists As Boolean
    Private bkpBitmap As Bitmap
    ' For Scaling Image
    Private ratio As Double
    Private myMattBitmap As Bitmap

    Private myAlpha As Byte

    Private myFormHeight As Integer = 535


    Public Sub ChangeColor(ByVal myOption As Integer)
        Dim bRGB As byteRGB, dHSL As doubleHSL
        Dim MeanBright As Double
        Dim Hue As Double, Sat As Double, Lum As Double
        Dim pixelColor As Color
        Dim pWid As Integer, pHei As Integer
        Dim I As Integer, J As Integer

        Try
            Me.ProgressBar1.Visible = True
            If Form1.MattTexture Is Nothing Then
                If strDropedFile = "" Then
                    myMattBitmap = New Bitmap(Me.PictureBox1.Width, Me.PictureBox1.Height)
                Else
                    myMattBitmap = New Bitmap(strDropedFile)
                End If
            Else
                myMattBitmap = Form1.MattTexture.Clone
            End If

            pWid = myMattBitmap.Width
            pHei = myMattBitmap.Height

            'NumericUpDown1.Value = TrackBar1.Value
            'NumericUpDown3.Value = TrackBar2.Value
            'TextBox3.Text = TrackBar3.Value
            MeanBright = Me.MeanBrightness(myMattBitmap)
            If myOption = 5 Then
                For I = 0 To pWid - 1
                    For J = 0 To pHei - 1
                        pixelColor = myMattBitmap.GetPixel(I, J)
                        'pixelColor = Color.FromArgb(myAlpha, pixelColor)
                        myMattBitmap.SetPixel(I, J, Color.FromArgb(myAlpha, pixelColor.R, pixelColor.G, pixelColor.B))
                    Next
                    Me.ProgressBar1.Value = (I + 1) * 100 / pWid
                Next
            Else
                For I = 0 To pWid - 1
                    For J = 0 To pHei - 1
                        pixelColor = myMattBitmap.GetPixel(I, J)
                        Hue = pixelColor.GetHue / 360.0
                        Sat = pixelColor.GetSaturation
                        Lum = pixelColor.GetBrightness
                        Select Case myOption
                            Case 1 ' Hue Change 
                                dHSL.H = Me.TrackBar1.Value / 360 + Hue
                                dHSL.L = Lum
                                dHSL.S = Sat
                            Case 2 ' Saturation Change
                                dHSL.H = Hue
                                dHSL.L = Lum
                                dHSL.S = Me.TrackBar2.Value / 100 * Sat
                            Case 3 ' Brightness Change
                                dHSL.H = Hue
                                dHSL.S = Sat
                                dHSL.L = Me.TrackBar3.Value / 100 * Lum
                            Case 4 ' Contrast Change
                                dHSL.H = Hue
                                dHSL.S = Sat
                                dHSL.L = Me.TrackBar4.Value / 100 * (Lum - MeanBright) + MeanBright
                            Case Else
                                ' No Operation
                        End Select
                        If dHSL.H >= 1.0 Then dHSL.H = dHSL.H - 1.0
                        If dHSL.S > 1.0 Then dHSL.S = 1.0
                        If dHSL.L > 1.0 Then dHSL.L = 1.0
                        If dHSL.L < 0.0 Then dHSL.L = 0.0

                        bRGB = HSL2RGB(dHSL)
                        pixelColor = Color.FromArgb(bRGB.R, bRGB.G, bRGB.B)
                        myMattBitmap.SetPixel(I, J, pixelColor)
                    Next
                    Me.ProgressBar1.Value = (I + 1) * 100 / pWid
                Next
            End If
            Me.PictureBox1.Image = myMattBitmap
            Form1.MattTexture = myMattBitmap
            Me.ProgressBar1.Visible = False
        Catch
            MessageBox.Show(Err.Description)
        End Try
    End Sub
    Function MeanBrightness(ByVal myMattBitmap As Bitmap) As Double
        Dim Bright As Double
        Dim pixelColor As Color
        Dim pWid As Integer, pHei As Integer
        Dim I As Integer, J As Integer

        pWid = myMattBitmap.Width
        pHei = myMattBitmap.Height
        For I = 0 To pWid - 1
            For J = 0 To pHei - 1
                pixelColor = myMattBitmap.GetPixel(I, J)
                Bright = Bright + pixelColor.GetBrightness
            Next
        Next
        MeanBrightness = Bright / CType(pWid, Double) / CType(pHei, Double)
    End Function

    Private Sub Form6_Disposed(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Disposed
        Form1.Refresh()
    End Sub

    Private Sub Form6_DragDrop(ByVal sender As Object, ByVal e As System.Windows.Forms.DragEventArgs) Handles Me.DragDrop
        If e.Data.GetDataPresent(DataFormats.FileDrop) Then
            Dim files As String() = CType(e.Data.GetData(DataFormats.FileDrop), String())
            strDropedFile = files(0)
            Try
                ConvertImage(files(0))
                Form1.Importedtexture = files(0)
                Me.Height = myFormHeight
            Catch ex As Exception
                MessageBox.Show(ex.Message)
                Return
            End Try
        ElseIf e.Data.GetDataPresent(DataFormats.Text, False) Then
            Dim mydata As String = e.Data.GetData(DataFormats.Text, True)
        Else
            MessageBox.Show("Image could not be obtained.")
        End If
        Me.Invalidate()

    End Sub

    Private Sub Form6_DragEnter(ByVal sender As Object, ByVal e As System.Windows.Forms.DragEventArgs) Handles Me.DragEnter

        If e.Data.GetDataPresent(DataFormats.Bitmap) _
            Or e.Data.GetDataPresent(DataFormats.Text) _
           Or e.Data.GetDataPresent(DataFormats.FileDrop) Then
            e.Effect = DragDropEffects.Copy
            'ElseIf e.Data.GetDataPresent("UniformResourceLocator") Then
            '    e.Effect = DragDropEffects.Link
        Else
            e.Effect = DragDropEffects.None
        End If

    End Sub

    Private Sub Form6_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Form1.MattTexture Is Nothing Then
            Dim myMattBitmap As New Bitmap(Me.PictureBox1.Width, Me.PictureBox1.Height)
            Me.PictureBox1.Image = myMattBitmap
            Me.Height = 263
        Else
            Me.PictureBox1.Image = Form1.MattTexture
            Me.Height = myFormHeight
        End If
        'NumericUpDown1.Value = TrackBar1.Value
        'NumericUpDown3.Value = TrackBar2.Value
        'TextBox3.Text = TrackBar3.Value
        'TextBox4.Text = TrackBar4.Value
        'NumericUpDown2.Value = Math.Round(CType(TrackBar5.Value / 50.0, Double), 1)

        Me.Button1.Visible = False
        Me.Button9.Visible = False

    End Sub

    Private Sub TrackBar1_MouseDown(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles TrackBar1.MouseDown
        SetButtonsInVisibleOnTrackMouseDown()
    End Sub

    Private Sub TrackBar1_ValueChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles TrackBar1.ValueChanged
        'TextBox1.Text = TrackBar1.Value
        NumericUpDown1.Value = TrackBar1.Value
    End Sub

    Private Sub TrackBar2_MouseDown(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles TrackBar2.MouseDown
        SetButtonsInVisibleOnTrackMouseDown()
    End Sub

    Private Sub TrackBar2_ValueChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles TrackBar2.ValueChanged
        'TextBox2.Text = TrackBar2.Value
        NumericUpDown3.Value = TrackBar2.Value
        If TrackBar2.Value > 100 Then
            Button13.Text = "Inclease Saturation"
        ElseIf TrackBar2.Value < 100 Then
            Button13.Text = "Decrease Saturation"
        Else
            Button13.Text = "Change Saturation"
        End If
    End Sub

    Private Sub TrackBar3_MouseDown(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles TrackBar3.MouseDown
        SetButtonsInVisibleOnTrackMouseDown()
    End Sub

    Private Sub TrackBar3_ValueChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles TrackBar3.ValueChanged
        NumericUpDown4.Value = TrackBar3.Value
        If TrackBar3.Value > 100 Then
            Button14.Text = "Inclease Brightness"
        ElseIf TrackBar3.Value < 100 Then
            Button14.Text = "Decrease Brightness"
        Else
            Button14.Text = "Change Brightness"
        End If
    End Sub

    Private Sub TrackBar4_MouseDown(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles TrackBar4.MouseDown
        SetButtonsInVisibleOnTrackMouseDown()
    End Sub

    Private Sub TrackBar4_ValueChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles TrackBar4.ValueChanged
        NumericUpDown5.Value = TrackBar4.Value
        If TrackBar4.Value > 100 Then
            Button15.Text = "Inclease Contrast"
        ElseIf TrackBar4.Value < 100 Then
            Button15.Text = "Decrese Contrast"
        Else
            Button15.Text = "Change Contrast"
        End If
    End Sub

    Private Sub Button2_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles Button2.Click
        'Dim oldBitmap As Bitmap
        Dim strOldBitMap As String

        If Form1.Importedtexture Is Nothing Then
            'oldBitmap = New Bitmap(strFile)
            strOldBitMap = Nothing
        Else
            'oldBitmap = Bitmap.FromFile(Form1.Importedtexture)
            strOldBitMap = Form1.Importedtexture
        End If
        ConvertImage(strOldBitMap)
        Form1.MattTexture = Me.PictureBox1.Image
        Me.Button1.Visible = True
        Me.Button9.Visible = True
    End Sub

    Public Sub New()
        Me.AllowDrop = True
        InitializeComponent()
    End Sub

    Public Function HSL2RGB(ByVal pHSL As doubleHSL) As byteRGB

        Dim dTmp1 As Double
        Dim dTmp2 As Double
        Dim dTmp(2) As Double
        Dim i As Byte

        Dim RGB As byteRGB

        If 0 > pHSL.H Or pHSL.H > 1 Or _
           0 > pHSL.S Or pHSL.S > 1 Or _
           0 > pHSL.L Or pHSL.L > 1 Then

            Debug.WriteLine("HSL Value is invalid.")
            Debug.WriteLine("pHSL.S  =  " & pHSL.S)
            Debug.WriteLine("pHSL.L  =  " & pHSL.L)
            Exit Function
        End If

        If pHSL.S = 0 Then
            RGB.R = CByte(255 * pHSL.L)
            RGB.G = RGB.R
            RGB.B = RGB.R
        Else
            If pHSL.L < 0.5 Then
                dTmp2 = pHSL.L * (pHSL.S + 1)
            Else
                dTmp2 = (pHSL.L + pHSL.S) - (pHSL.L * pHSL.S)
            End If
            dTmp1 = (2 * pHSL.L) - dTmp2
            dTmp(0) = pHSL.H - (2 / 3)
            dTmp(1) = pHSL.H
            dTmp(2) = pHSL.H - (1 / 3)

            For i = 0 To 2
                If dTmp(i) < 0 Then dTmp(i) = dTmp(i) + 1
                If 6 * dTmp(i) < 1 Then
                    dTmp(i) = dTmp1 + 6 * dTmp(i) * (dTmp2 - dTmp1)
                ElseIf 2 * dTmp(i) < 1 Then
                    dTmp(i) = dTmp2
                ElseIf 3 * dTmp(i) < 2 Then
                    dTmp(i) = dTmp1 + 6 * ((2 / 3) - dTmp(i)) * (dTmp2 - dTmp1)
                Else
                    dTmp(i) = dTmp1
                End If
            Next i

            RGB.R = CByte(255 * dTmp(0))
            RGB.G = CByte(255 * dTmp(1))
            RGB.B = CByte(255 * dTmp(2))

        End If
        HSL2RGB = RGB
    End Function

    Private Sub Button4_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles Button4.Click
        Form1.MattTexture = Me.PictureBox1.Image
        Form1.AddMatTexture()
    End Sub

    Private Sub Button5_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles Button5.Click
        Form1.PictureBox2.Image = Nothing
        Form1.MattTexture = Nothing
        Form1.Refresh()
        Me.Button1.Visible = False
    End Sub

    Private Sub ImportTextureImage()
        Dim myDirectory As String
        Dim dlg As OpenFileDialog

        Try
            myDirectory = "My Pictures"
            dlg = OpenFileDialog1
            With dlg
                .Filter = "Image Files(*.jpg,*.bmp,*.gif,*png)|*.jpg;*.bmp;*.gif;*.png|All Files(*.*)|*.*"
                .Title = "Import Texture Image."
                .FileName = ""
                .InitialDirectory = myDirectory
                .Multiselect = False
                If .ShowDialog() = Windows.Forms.DialogResult.OK Then
                    strDropedFile = .FileName
                    Form1.Importedtexture = strDropedFile
                    ConvertImage(strDropedFile)
                    Me.Height = myFormHeight
                End If
                .Dispose()
            End With
            Me.Button1.Visible = True
            Me.Button9.Visible = True
        Catch
            MessageBox.Show(Err.Description)
        End Try
    End Sub

    Private Sub ConvertImage(ByVal strFile As String)
        Try
            Dim myRect As Rectangle
            Dim myMattBitmap As Bitmap
            myMattBitmap = Bitmap.FromFile(strFile)
            myRect.X = 0 : myRect.Y = 0
            myRect.Width = myMattBitmap.Width - 1 : myRect.Height = myMattBitmap.Height - 1
            Me.PictureBox1.Image = myMattBitmap.Clone(myRect, Imaging.PixelFormat.Format32bppArgb)
            Form1.MattTexture = Me.PictureBox1.Image
            myMattBitmap.Dispose()
        Catch
            MessageBox.Show(Err.Description)
        End Try
    End Sub

    Private Sub Button6_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles Button6.Click
        ImportTextureImage()
    End Sub

    Private Sub Button7_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles Button7.Click
        TrackBar1.Value = 0
        TrackBar2.Value = 100
        TrackBar3.Value = 100
        TrackBar4.Value = 100
        TrackBar5.Value = 50
        ProgressBar1.Value = 0
    End Sub

    Private Sub Button8_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles Button8.Click
        DoPaste()
    End Sub

    Private Sub DoPaste()
        Try
            Dim iData As IDataObject
            Dim myMattBitmap As Bitmap
            Dim strImage As String

            iData = Clipboard.GetDataObject

            If iData.GetDataPresent(DataFormats.Bitmap) Then
                myMattBitmap = CType(iData.GetData(DataFormats.Bitmap), Bitmap)
                strImage = "C:\myImage.bmp"
                myMattBitmap.Save(strImage)
                Form1.Importedtexture = strImage
                Application.DoEvents()
                ConvertImage(strImage)
                myMattBitmap.Dispose()
                Me.Button1.Visible = True
                Me.Button9.Visible = True
                Me.Height = myFormHeight

            ElseIf iData.GetDataPresent(DataFormats.Locale) Then
                MessageBox.Show("To import back ground image of home page, save the back ground, then use browse button, or drag and drop the saved image file.")

            Else
                MsgBox("Image could not be obtained.")
            End If
        Catch
            Me.Close()
            MessageBox.Show(Err.Description)
        End Try
    End Sub

    Private Sub Button9_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles Button9.Click
        Me.PictureBox1.Image.RotateFlip(RotateFlipType.Rotate90FlipNone)
        PictureBox1.Width = Me.PictureBox1.Image.Width
        PictureBox1.Height = Me.PictureBox1.Image.Height
        Me.PictureBox1.Invalidate()
    End Sub

    Private Sub Button10_Click(ByVal sender As Object, ByVal e As System.EventArgs)
        ChangeColor(1)
    End Sub

    Private Sub Button3_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles Button3.Click
        Me.Close()
    End Sub

    Private Sub PictureBox1_MouseDown(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles PictureBox1.MouseDown
        If isClipRectExists = False Then
            bkpBitmap = PictureBox1.Image.Clone
        End If
        startPoint = PictureBox1.PointToClient(Control.MousePosition)
        Me.Cursor = Cursors.Cross
    End Sub

    Private Sub PictureBox1_MouseUp(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles PictureBox1.MouseUp
        Dim g As Graphics = Graphics.FromImage(PictureBox1.Image)
        Dim myPen As New Pen(Brushes.DeepSkyBlue)
        Dim endPoint As Point

        endPoint = PictureBox1.PointToClient(Control.MousePosition)
        ClippingRect.X = startPoint.X
        ClippingRect.Y = startPoint.Y
        ClippingRect.Width = endPoint.X - startPoint.X
        ClippingRect.Height = endPoint.Y - startPoint.Y
        g.DrawRectangle(myPen, ClippingRect)
        g.Dispose()
        PictureBox1.Invalidate()
        Me.Cursor = Cursors.Default
        isClipRectExists = True
    End Sub

    Private Sub DoClipping()
        Try
            Me.PictureBox1.Image = bkpBitmap.Clone(ClippingRect, Imaging.PixelFormat.Format32bppArgb)
            Form1.MattTexture = Me.PictureBox1.Image
            bkpBitmap.Dispose()
            PictureBox1.Invalidate()
            isClipRectExists = False
        Catch
            MessageBox.Show(Err.Description)
        End Try
    End Sub

    Private Sub Button1_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles Button1.Click
        DoClipping()
    End Sub

    Private Sub SetButtonsInVisibleOnTrackMouseDown()
        Me.Button1.Visible = False
    End Sub

    Private Sub TestToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles TestToolStripMenuItem.Click
        DoPaste()
    End Sub

    Private Sub Button10_Click1(ByVal sender As Object, ByVal e As System.EventArgs) Handles Button10.Click
        Dim myDirectory As String
        Dim myFileName As String
        Dim bSave As Boolean = True
        Try
            myDirectory = "My Documents"
            With SaveFileDialog1
                .InitialDirectory = myDirectory
                .Filter = "JGP Files(*.jpg)|*.jpg"
                If (.ShowDialog() = Windows.Forms.DialogResult.OK) Then
                    myFileName = .FileName
                    If myFileName = Form1.ImageFileName Then
                        If MessageBox.Show("You are replacing existing file with new file." & vbLf & "Do you wish really to replace them.", "Confirming Replace", MessageBoxButtons.YesNo, MessageBoxIcon.Question) = Windows.Forms.DialogResult.No Then
                            bSave = False
                        End If
                    End If
                    If bSave = True Then
                        Me.PictureBox1.Image.Save(myFileName, System.Drawing.Imaging.ImageFormat.Jpeg)
                    End If
                End If
                .Dispose()
            End With
        Catch
            MessageBox.Show(Err.Description)
        End Try

    End Sub

    Private Sub Button12_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles Button12.Click
        ChangeColor(1)
    End Sub

    Private Sub Button13_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles Button13.Click
        ChangeColor(2)
    End Sub

    Private Sub Button14_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles Button14.Click
        ChangeColor(3)
    End Sub

    Private Sub Button15_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles Button15.Click
        ChangeColor(4)
    End Sub

    Private Sub TrackBar5_MouseDown(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles TrackBar5.MouseDown
        SetButtonsInVisibleOnTrackMouseDown()
    End Sub

    Private Sub TrackBar5_ValueChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles TrackBar5.ValueChanged
        Try
            ratio = CType(TrackBar5.Value / 50.0, Double)
            'TextBox5.Text = Math.Round(ratio, 1)
            NumericUpDown2.Value = Math.Round(ratio, 1)
            If TrackBar5.Value > 50 Then
                Button11.Text = "Scale Up"
            ElseIf TrackBar5.Value < 50 Then
                Button11.Text = "Scale Down"
            Else
                Button11.Text = "Change Scale"
            End If
        Catch
            MessageBox.Show(Err.Description)
        End Try

    End Sub

    Private Sub Button11_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles Button11.Click
        Try
            Dim rect As RectangleF
            Dim rectBmp As RectangleF
            Dim myMattBitmap As Bitmap
            rect = New RectangleF(0, 0, ratio * PictureBox1.Image.Width, ratio * PictureBox1.Image.Height)
            Dim bmp As New Bitmap(rect.Width, rect.Height, System.Drawing.Imaging.PixelFormat.Format32bppArgb)
            Dim g As Graphics = Graphics.FromImage(bmp)
            If ratio <= 1.0F Then
                rectBmp = rect
            Else
                rectBmp = New RectangleF(0, 0, ratio * PictureBox1.Image.Width + 1.0F * ratio, ratio * PictureBox1.Image.Height + 1.0F * ratio)
            End If
            g.DrawImage(PictureBox1.Image, rectBmp)
            myMattBitmap = bmp.Clone

            PictureBox1.Image = myMattBitmap
            Form1.MattTexture = myMattBitmap
            bmp.Dispose()
            g.Dispose()
        Catch
            MessageBox.Show(Err.Description)
        End Try
    End Sub

    Private Sub TrackBar6_ValueChanged(ByVal sender As System.Object, ByVal e As System.EventArgs)
        'TextBox6.Text = TrackBar6.Value
        'myAlpha = CType(255.0F / 100.0F * TrackBar6.Value, Byte)
    End Sub

    Private Sub Button16_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)
        ChangeColor(5)
    End Sub

    Private Sub NumericUpDown1_ValueChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles NumericUpDown1.ValueChanged
        TrackBar1.Value = NumericUpDown1.Value
    End Sub

    Private Sub NumericUpDown2_ValueChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles NumericUpDown2.ValueChanged
        TrackBar5.Value = CType(50.0F * NumericUpDown2.Value, Integer)
    End Sub

    Private Sub NumericUpDown3_ValueChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles NumericUpDown3.ValueChanged
        TrackBar2.Value = NumericUpDown3.Value
    End Sub

    Private Sub NumericUpDown4_ValueChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles NumericUpDown4.ValueChanged
        TrackBar3.Value = NumericUpDown4.Value
    End Sub

    Private Sub NumericUpDown5_ValueChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles NumericUpDown5.ValueChanged
        TrackBar4.Value = NumericUpDown5.Value
    End Sub
End Class
